IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Tickets_Vendidos') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Tickets_Vendidos
END
GO

CREATE PROCEDURE [dbo].[CPJ_Tickets_Vendidos]		@pJson VARCHAR(8000)
AS 
SET NOCOUNT ON

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT
		,@pModoDebug			TINYINT
		,@pId_Lista_Precio		INT
		,@pId_Cliente			INT
		,@pId_Sector			INT



SET @pFlagUsarTrans			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Lista_Precio		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Lista_Precio')), 0)
SET @pId_Cliente			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')), 0)
SET @pId_Sector				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Sector')), 0)
/*FIN Variables recibidas por parametro a traves del JSON*/

/*====================================================================================================================================================*/

/*Variables Locales*/
DECLARE @SqlStr						NVARCHAR(MAX)
DECLARE @Id_Cliente_Ref				INT
DECLARE @Id_Evento_Grupo			INT
DECLARE @Evento_Desde				DATE
DECLARE @Evento_Hasta				DATE
DECLARE @Flag_Localidades			TINYINT
DECLARE @Fecha_Evento				DATETIME
DECLARE @Id_Evento_Grupo_Reservas	INT
DECLARE @Evento_Fecha_Reserva_Limite DATETIME
DECLARE @Tipo_Cbte_VW_Pedido		VARCHAR(4)
DECLARE @Tipo_Cbte_VW_Factura		VARCHAR(4)
DECLARE @cant_min_reserva			INT
DECLARE @version_SQL				VARCHAR(50)
DECLARE @Id_lista_Origen			INT
/*FIN Variables Locales*/

BEGIN TRY
	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Tickets_Vendidos'
		PRINT 'Parametros: '+ @pJson  
	END

	/*====================================================================================================================================================*/

	SET @version_SQL = dbo.CF_DB_Version()

	/*====================================================================================================================================================*/

	IF(@pId_Cliente > 0)
	BEGIN
		SELECT 		
		@Id_Cliente_Ref = ISNULL(Id_Cliente_Ref, 0)
		FROM Clientes 
		WHERE
		Id_Cliente = @pId_Cliente

		IF(@Id_Cliente_Ref = 0)
		BEGIN
			SET @Id_Cliente_Ref = @pId_Cliente
		END
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@pId_Cliente: ' + CONVERT(VARCHAR(10), @pId_Cliente) + '. @Id_Cliente_Ref: '+ CONVERT(VARCHAR(10), @Id_Cliente_Ref)  
	END

	/*====================================================================================================================================================*/

	IF OBJECT_ID('tempdb..#Rta_CPJ_Tickets_Vendidos') IS NOT NULL
	BEGIN
		DROP TABLE #Rta_CPJ_Tickets_Vendidos
	END

	CREATE TABLE #Rta_CPJ_Tickets_Vendidos		(Id_Trans				INT
												, Id_Cliente			INT
												, Id_Lista				INT
												, Razon_Social			VARCHAR(100)
												, Fecha_QA				DATETIME
												, Fecha_Venc			DATETIME
												, Fecha_Desde			DATETIME
												, Fecha_Hasta			DATETIME
												, Descripcion			VARCHAR(100)
												, Id_Producto			VARCHAR(14)
												, Descripcion_Resumida	VARCHAR(100)
												, Estado				VARCHAR(10)
												, Serie					VARCHAR(100)
												, Item					INT
												, Flag_QA				CHAR(1)
												, Fecha_Cbte			DATETIME
												, Cbte_Descrip			VARCHAR(50)
												, Id_Estado_Cbte		SMALLINT
												, Cantidad				INT
												, Lote					VARCHAR(20)
												, Id_Sector				SMALLINT
												, Sector_Codigo			VARCHAR(10)
												, Sector_Nombre			VARCHAR(50)
												, Columna				VARCHAR(5)
												, Fila					VARCHAR(5)
												, Fecha_Evento			DATETIME
												, Id_Lista_Renov		INT
												)

	CREATE INDEX #IX_Rta_CPJ_Loc_Ocup_Prod ON #Rta_CPJ_Tickets_Vendidos (Id_Producto)

	CREATE INDEX #IX_Rta_CPJ_Loc_Ocup_ColFil ON #Rta_CPJ_Tickets_Vendidos (Sector_Codigo,Id_Sector,Columna,Fila)

	/*====================================================================================================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@pId_Lista_Precio: '+ CONVERT(VARCHAR(10), @pId_Lista_Precio)  
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Actualiza Evento_Cant_Dias_Limite y Evento_Fecha_Reserva_Limite en caso de ser Abonos y no tenerlo configurado.'
	END

	IF(@pId_Lista_Precio > 0)
	BEGIN
		UPDATE Prod_Listas_Precios 
		SET 
		Evento_Cant_Dias_Limite = CONVERT(INT, dbo.CF_xParam('Loca_Fecha_Lim_Dias'))
		WHERE 
		Id_Lista_Precio = @pId_Lista_Precio  
		AND Evento_Cant_Dias_Limite = 0
		AND Flag_Localidades = 1

		UPDATE Prod_Listas_Precios 
				SET 
				Evento_Fecha_Reserva_Limite = CONVERT(DATE,dbo.CF_xParam('Loca_Fecha_Lim'))
				WHERE 
				Id_Lista_Precio = @pId_Lista_Precio 
				AND Evento_Fecha_Reserva_Limite IS NULL
				AND Flag_Localidades = 1

		SELECT	
				@Id_Evento_Grupo = ISNULL(Id_Evento_Grupo, 0), 
				@Evento_Desde = Fecha_Desde , 
				@Evento_Hasta = Fecha_Hasta , 
				@Flag_Localidades = Flag_Localidades,
				@Fecha_Evento = Fecha_Evento,
				@Evento_Fecha_Reserva_Limite = Evento_Fecha_Reserva_Limite		
				FROM Prod_Listas_Precios 
				WHERE 
				Id_Lista_Precio = @pId_Lista_Precio	

	   SELECT  TOP 1
			   @Id_Evento_Grupo_Reservas = Id_Evento_Grupo_Reservas
			   FROM Eventos_Grupos 
			   WHERE Id_Evento_Grupo = @Id_Evento_Grupo 
			   

		/* Si es partido, tomo la fecha del partido*/
		IF @Flag_Localidades = 2
		BEGIN
			  SET @Evento_Desde = @Fecha_Evento 
			  SET @Evento_Hasta = @Fecha_Evento  
		END

		IF(@pModoDebug = 1)
		BEGIN
			PRINT '@Id_Evento_Grupo: '+ CONVERT(VARCHAR(10), @Id_Evento_Grupo)  
			PRINT '@Evento_Desde: '+ CONVERT(VARCHAR(10), @Evento_Desde, 112)  
			PRINT '@Evento_Hasta: '+ CONVERT(VARCHAR(10), @Evento_Hasta, 112)  
			PRINT '@Flag_Localidades: '+ CONVERT(VARCHAR(10), @Flag_Localidades)  
			PRINT '@Fecha_Evento: '+ CONVERT(VARCHAR(20), @Fecha_Evento, 112)  
			PRINT '@Evento_Fecha_Reserva_Limite: '+ CONVERT(VARCHAR(10), @Evento_Fecha_Reserva_Limite, 112)  
			PRINT '@Id_Evento_Grupo_Reservas: '+ CONVERT(VARCHAR(10), ISNULL(@Id_Evento_Grupo_Reservas,0))  
		END
	END
	ELSE
	BEGIN
		SET @Evento_Desde = GETDATE() 
		SET @Evento_Hasta = GETDATE()
		SET @Evento_Fecha_Reserva_Limite = CONVERT(DATE, dbo.CF_xParam('Loca_Fecha_Lim'))		
	END


	/*=======================================================================VENTAS y REMITOS de Fechas(Partidos) CON PRECIO  =============================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'VENTAS y REMITOS DE FECHAS (PARTIDOS) CON PRECIO'
	END

	SET @Tipo_Cbte_VW_Factura	= LTRIM(RTRIM(dbo.CF_xParam('Tipo_Cbte_VW_Factura')))

	SET @SqlStr =	''

	SET @SqlStr +=	'INSERT INTO #Rta_CPJ_Tickets_Vendidos '
	SET @SqlStr +=	' SELECT'
	SET @SqlStr +=	' DISTINCT'
	SET @SqlStr +=	' CB.Id_Trans,'
	SET @SqlStr +=	' ISNULL(CI.Id_Cliente, 0) AS Id_Cliente,'
	SET @SqlStr +=	' ISNULL(CB.Id_Lista, 0) AS Id_Lista,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CL.Razon_Social, '''')))) AS Razon_Social,'
	SET @SqlStr +=	' CI.Fecha_QA,'
	SET @SqlStr +=	' CI.Fecha_Venc,'
	SET @SqlStr +=	' PLP.Fecha_Desde,'
	SET @SqlStr +=	' PLP.Fecha_Hasta,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(PLP.Descripcion, '''')))) AS Descripcion,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CI.Id_Producto, '''')))) AS Id_Producto,'
	SET @SqlStr +=	' UPPER(RTRIM(LTRIM(ISNULL(PR.Descripcion_Resumida, '''')))) AS Descripcion_Resumida,'
	SET @SqlStr +=	'''TV'' AS Estado,'
					/*   
						TV	-> Ticket Vendido
						TC	-> Ticket Canjeado
						TI	-> Ticket Impreso
					*/
	SET @SqlStr +=	' CI.Serie,'
	SET @SqlStr +=	' CI.Item,'
	SET @SqlStr +=	' CI.Flag_QA,'
	SET @SqlStr +=	' CB.Fecha,'
	SET @SqlStr +=	' dbo.CF_Cbte_Descrip(CB.Id_Trans) AS Cbte_Descrip,'
	SET @SqlStr +=	' CB.Id_Estado_Cbte,'
	SET @SqlStr +=	' CONVERT(INT, CI.Cantidad) AS Cantidad,'
	SET @SqlStr +=	' CB.Lote,'
	SET @SqlStr +=	' PR.Id_Sector,'
	SET @SqlStr +=	' S.Codigo AS Sector_Codigo,'
	SET @SqlStr +=	' S.Descripcion AS Sector_Nombre,'
	SET @SqlStr +=	' PR.Columna,'
	SET @SqlStr +=	' PR.Fila,'
	SET @SqlStr +=	' PLP.Fecha_Evento,'
	SET @SqlStr +=	' ISNULL(CB.Id_Lista, 0)'
	SET @SqlStr +=	' FROM Cbtes CB, Cbtes_Items CI, Productos PR, Clientes CL, Prod_Listas_Precios PLP, Cbtes_Tipos CT, Empresas_Sedes_Sectores S'
	SET @SqlStr +=	' WHERE'
	SET @SqlStr +=	' CB.Id_Trans = CI.Id_Trans'
	SET @SqlStr +=	' AND CI.Id_Producto = PR.Id_Producto'
	SET @SqlStr +=	' AND PR.Id_Sector = S.Id_Sector'
	SET @SqlStr +=	' AND CI.Id_Cliente = CL.Id_Cliente'
	SET @SqlStr +=	' AND CB.Id_Lista = PLP.Id_Lista_Precio'
	SET @SqlStr +=	' AND CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte'
	SET @SqlStr +=	' AND CL.Activo = 1 '
	SET @SqlStr +=	' AND (CT.Compromete_Factura = 1 OR Compromete_Remitos = 1) ' 
	SET @SqlStr +=	' AND CB.Id_Estado_Cbte IN (2) '	
	SET @SqlStr +=	' AND PLP.Flag_Localidades = 2'
	SET @SqlStr +=	' AND NOT EXISTS (SELECT 1 FROM #Rta_CPJ_Tickets_Vendidos AUXRTA WHERE AUXRTA.ID_TRANS = CI.ID_TRANS AND AUXRTA.ITEM = CI.ITEM)'
	SET @SqlStr +=	' AND CONVERT(DATE,PLP.Fecha_Hasta) >= CONVERT(DATE,GETDATE()) '	
	SET @SqlStr +=	' AND PR.Tipo = ''L'''
	SET @SqlStr +=	' AND CI.Flag_QA IN (''A'',''B'')'

	IF @Flag_Localidades = 2
	BEGIN
		SET @SqlStr +=	' AND CONVERT(VARCHAR(8),PLP.Fecha_Evento,112) = '''+ CONVERT(VARCHAR(8),@Fecha_Evento,112) +''''
    END

	IF(@pId_Cliente <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND (CL.Id_Cliente = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) +  ' OR CL.Id_Cliente_Ref = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) + ')'
	END

	IF(@pId_Lista_Precio > 0)
	BEGIN
		IF(@Id_Evento_Grupo <> 0)
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PLP.Id_Lista_Precio IN (SELECT PLG.Id_Lista_Precio 
																						   FROM Prod_Listas_Precios PLG
																						   WHERE 
																						   PLG.Id_Evento_Grupo = ' + CONVERT(VARCHAR(10), @Id_Evento_Grupo) + '
																						   AND PLG.Flag_Localidades = 2)'
		END
		ELSE
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PLP.Id_Lista_Precio = '+ CONVERT(VARCHAR(10),@pId_Lista_Precio)
		END 
	END
	
	IF(@pId_Sector <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Sector = ' + CONVERT(VARCHAR(20),@pId_Sector) 
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@SqlStr: ' + @SqlStr
	END

	EXECUTE sp_executesql @SqlStr

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
	END

	/*=======================================================================VENTAS y REMITOS de Fechas(Partidos) SIN PRECIO (CANJES)===========================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'VENTAS y REMITOS DE FECHAS (PARTIDOS) SIN PRECIO (CANJES)'
	END

	SET @Tipo_Cbte_VW_Pedido	= LTRIM(RTRIM(dbo.CF_xParam('Tipo_Cbte_VW_Pedido')))

	SET @SqlStr =	''

	SET @SqlStr +=	'INSERT INTO #Rta_CPJ_Tickets_Vendidos '
	SET @SqlStr +=	' SELECT'
	SET @SqlStr +=	' DISTINCT'
	SET @SqlStr +=	' CB.Id_Trans,'
	SET @SqlStr +=	' ISNULL(CI.Id_Cliente, 0) AS Id_Cliente,'
	SET @SqlStr +=	' ISNULL(CB.Id_Lista, 0) AS Id_Lista,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CL.Razon_Social, '''')))) AS Razon_Social,'
	SET @SqlStr +=	' CI.Fecha_QA,'
	SET @SqlStr +=	' CI.Fecha_Venc,'
	SET @SqlStr +=	' PLP.Fecha_Desde,'
	SET @SqlStr +=	' PLP.Fecha_Hasta,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(PLP.Descripcion, '''')))) AS Descripcion,'
	SET @SqlStr +=	' UPPER(LTRIM(RTRIM(ISNULL(CI.Id_Producto, '''')))) AS Id_Producto,'
	SET @SqlStr +=	' UPPER(RTRIM(LTRIM(ISNULL(PR.Descripcion_Resumida, '''')))) AS Descripcion_Resumida,'
	SET @SqlStr +=	'''TC'' AS Estado,'
					/*   
						TV	-> Ticket Vendido
						TC	-> Ticket Canjeado
						TI	-> Ticket Impreso
					*/
	SET @SqlStr +=	' CI.Serie,'
	SET @SqlStr +=	' CI.Item,'
	SET @SqlStr +=	' CI.Flag_QA,'
	SET @SqlStr +=	' CB.Fecha,'
	SET @SqlStr +=	' dbo.CF_Cbte_Descrip(CB.Id_Trans) AS Cbte_Descrip,'
	SET @SqlStr +=	' CB.Id_Estado_Cbte,'
	SET @SqlStr +=	' CONVERT(INT, CI.Cantidad) AS Cantidad,'
	SET @SqlStr +=	' CB.Lote,'
	SET @SqlStr +=	' PR.Id_Sector,'
	SET @SqlStr +=	' S.Codigo AS Sector_Codigo,'
	SET @SqlStr +=	' S.Descripcion AS Sector_Nombre,'
	SET @SqlStr +=	' PR.Columna,'
	SET @SqlStr +=	' PR.Fila,'
	SET @SqlStr +=	' PLP.Fecha_Evento,'
	SET @SqlStr +=	' ISNULL(CB.Id_Lista, 0)'
	SET @SqlStr +=	' FROM Cbtes CB, Cbtes_Items CI, Productos PR, Clientes CL, Prod_Listas_Precios PLP, Cbtes_Tipos CT, Empresas_Sedes_Sectores S'
	SET @SqlStr +=	' WHERE'
	SET @SqlStr +=	' CB.Id_Trans = CI.Id_Trans'
	SET @SqlStr +=	' AND CI.Id_Producto = PR.Id_Producto'
	SET @SqlStr +=	' AND PR.Id_Sector = S.Id_Sector'
	SET @SqlStr +=	' AND CI.Id_Cliente = CL.Id_Cliente'
	SET @SqlStr +=	' AND CB.Id_Lista = PLP.Id_Lista_Precio'
	SET @SqlStr +=	' AND CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte'
	SET @SqlStr +=	' AND CL.Activo = 1 '
	SET @SqlStr +=	' AND CT.Compromete_Pedido = 1 ' 
	SET @SqlStr +=	' AND CT.Id_Tipo_Cbte = ''' + @Tipo_Cbte_VW_Pedido + ''''
	SET @SqlStr +=	' AND CB.Id_Estado_Cbte IN (2) '
	SET @SqlStr +=	' AND PLP.Flag_Localidades = 2'
	SET @SqlStr +=	' AND NOT EXISTS (SELECT 1 FROM #Rta_CPJ_Tickets_Vendidos AUXRTA WHERE AUXRTA.ID_TRANS = CI.ID_TRANS AND AUXRTA.ITEM = CI.ITEM)'
	SET @SqlStr +=	' AND CONVERT(DATE,PLP.Fecha_Hasta) >= CONVERT(DATE,GETDATE()) ' 
	SET @SqlStr +=	' AND PR.Tipo = ''L'''
	SET @SqlStr +=	' AND CI.Flag_QA IN (''A'',''B'')'

	IF @Flag_Localidades = 2
	BEGIN
		SET @SqlStr +=	' AND CONVERT(VARCHAR(8),PLP.Fecha_Evento,112) = '''+ CONVERT(VARCHAR(8),@Fecha_Evento,112) +''''
    END

	IF(@pId_Cliente <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND (CL.Id_Cliente = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) +  ' OR CL.Id_Cliente_Ref = ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref) + ')'
	END

	IF(@pId_Lista_Precio > 0)
	BEGIN
		IF(@Id_Evento_Grupo <> 0)
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PLP.Id_Lista_Precio IN (SELECT PLG.Id_Lista_Precio 
																						   FROM Prod_Listas_Precios PLG
																						   WHERE 
																						   PLG.Id_Evento_Grupo = ' + CONVERT(VARCHAR(10), @Id_Evento_Grupo) + '
																						   AND PLG.Flag_Localidades = 2)'
		END
		ELSE
		BEGIN
			SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PLP.Id_Lista_Precio = '+ CONVERT(VARCHAR(10),@pId_Lista_Precio)
		END 
	END

	
	IF(@pId_Sector <> 0)
	BEGIN
		SET @SqlStr = RTRIM(LTRIM(@SqlStr)) + CHAR(13) +' AND PR.Id_Sector = ' + CONVERT(VARCHAR(20),@pId_Sector) 
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@SqlStr: ' + @SqlStr
	END

	EXECUTE sp_executesql @SqlStr

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
	END

	/*====================================================================================================================================================*/

		SELECT Id_lista, 0 AS Id_Lista_Renov INTO #Renov FROM #Rta_CPJ_Tickets_Vendidos WHERE 1=0
		IF(@pId_Cliente > 0)
		BEGIN

			DECLARE Cur_Renov CURSOR FOR 
			SELECT DISTINCT(Id_lista) FROM #Rta_CPJ_Tickets_Vendidos

			OPEN Cur_Renov
			FETCH NEXT FROM Cur_Renov INTO @Id_lista_Origen
			WHILE @@FETCH_STATUS = 0
			BEGIN

				INSERT #Renov (Id_lista, Id_Lista_Renov)
				VALUES (@Id_lista_Origen, dbo.CFUJ_Venta_Abono_Lista_Renovacion ('{"ModoDebug":"0", 
																			   "Id_Cliente":"' + CONVERT(VARCHAR(15),@pId_Cliente) + '", 
																			   "Id_Lista_Precio_Abono_Origen":"'+ CONVERT(VARCHAR(10),@Id_lista_Origen)  +'", 
																			   "Fecha":"'+ CONVERT(VARCHAR(15),GETDATE(),112) +'"}'))

				FETCH NEXT FROM Cur_Renov INTO @Id_lista_Origen
			END
			CLOSE Cur_Renov
			DEALLOCATE Cur_Renov

			UPDATE #Rta_CPJ_Tickets_Vendidos SET Id_Lista_Renov = CASE ISNULL(L.Id_Lista_Renov ,0)
																			WHEN 0 THEN R.Id_lista
																			ELSE L.Id_Lista_Renov
																			END 
					FROM #Rta_CPJ_Tickets_Vendidos R LEFT OUTER JOIN #Renov L ON R.Id_lista = L.Id_lista
					
			SELECT I.Id_Producto INTO #Rta_2 
				FROM Cbtes_Items I, Cbtes C, Cbtes_Tipos T, Prod_Listas_Precios L ,#Rta_CPJ_Tickets_Vendidos O
			    WHERE I.Id_Trans = C.Id_Trans
					AND C.Id_Tipo_Cbte = T.Id_Tipo_Cbte AND (T.Compromete_Factura = 1 OR T.Compromete_Remitos = 1 OR T.Compromete_Pedido = 1 ) 
					AND C.Id_Estado_Cbte IN (1,2,4)
					AND C.Id_Lista = L.Id_Lista_Precio 
					AND I.Id_Producto COLLATE SQL_Latin1_General_CP1_CI_AS = O.Id_Producto COLLATE SQL_Latin1_General_CP1_CI_AS
					AND C.Id_Lista IN (SELECT R.Id_Lista_Precio FROM Prod_Listas_Precios R , Eventos_Grupos E 
					        WHERE R.Id_Evento_Grupo = E.Id_Evento_Grupo AND E.Id_Evento_Grupo_Reservas = @Id_Evento_Grupo_Reservas)		        
			
			UPDATE #Rta_CPJ_Tickets_Vendidos SET Estado='A' WHERE Id_Producto COLLATE SQL_Latin1_General_CP1_CI_AS  IN (SELECT Id_Producto COLLATE SQL_Latin1_General_CP1_CI_AS  FROM #Rta_2) AND Estado='ARA'

		END

		SELECT * 
			FROM #Rta_CPJ_Tickets_Vendidos R 
			ORDER BY Sector_Codigo,Id_Sector,Columna,Fila
	 
		IF OBJECT_ID('tempdb..#Renov') IS NOT NULL
		BEGIN
			DROP TABLE #Renov
		END

		IF OBJECT_ID('tempdb..#Rta_2') IS NOT NULL
		BEGIN
			DROP TABLE #Rta_2
		END

	/*====================================================================================================================================================*/

	IF OBJECT_ID('tempdb..#Rta_CPJ_Tickets_Vendidos') IS NOT NULL
	BEGIN
		DROP TABLE #Rta_CPJ_Tickets_Vendidos
	END

	IF OBJECT_ID('tempdb..#Tot_Sector') IS NOT NULL
	BEGIN
		DROP TABLE #Tot_Sector
	END

	IF OBJECT_ID('tempdb..#Tot_Sector_L') IS NOT NULL
	BEGIN
		DROP TABLE #Tot_Sector_L
	END

	IF OBJECT_ID('tempdb..#Tot_Sector_O') IS NOT NULL
	BEGIN
		DROP TABLE #Tot_Sector_O
	END


	/*====================================================================================================================================================*/

	IF @pFlagUsarTrans <> 0 COMMIT
	
	/*====================================================================================================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: [CPJ_Tickets_Vendidos]'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0  ROLLBACK

	RETURN 9999
END CATCH

RETURN 0 

/*
EXEC CPJ_Tickets_Vendidos '{"FlagUsarTrans":"0", "ModoDebug":"0", "Id_Sector":"", "Id_Cliente":"37819", "Id_Lista_Precio":"" }'
*/
